/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.iw.tasks.newusers;

import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.common.util.HSCLocalizableMsg;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.iw.WizardBaseTask;
import com.ibm.hsc.iw.WizardCommitStatus;
import com.ibm.hsc.iw.WizardFrame;
import com.ibm.hsc.iw.WizardTaskException;
import com.ibm.hsc.iw.WizardTaskPanel;
import com.ibm.hsc.iw.WizardTaskState;
import com.ibm.hsc.iw.tasks.newusers.NewUsersConstants;
import com.ibm.hsc.iw.tasks.newusers.NewUsersState;
import com.ibm.hwmca.base.userprof.RoleTree;
import com.ibm.hwmca.base.userprof.UserAttributes;
import com.ibm.hwmca.base.userprof.UserProfTasklet;
import com.ibm.hwmca.base.userprof.UserProfilesPlugin;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class NewUsersTask
extends WizardBaseTask
implements NewUsersConstants {
    private static final String TRACE_MASKD = "JIWZNUTD";
    private static final String TRACE_MASKF = "JIWZNUTF";
    private static final String TRACE_MASKT = "JIWZNUTT";
    private static final String CUSTOMIZE_XML = "customize.xml";
    UserProfilesPlugin userProfilesPlugin = null;
    List taskRolesList = new ArrayList();
    List curUsersList = new ArrayList();

    public NewUsersTask() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->NewUsersTask()");
        }
    }

    public static void main(String[] stringArray) {
        if (Trace.LEVEL >= 3) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(' ');
                stringBuffer.append(stringArray[i]);
            }
            Trace.trace(TRACE_MASKD, "main() called with the following parameters :" + stringBuffer.toString());
        }
    }

    public LocalizableText getDescription() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->getDescription()");
        }
        return new LocalizableText("com.ibm.hsc.common.bundles.NewUsersText", "TASK_DESCRIPTION");
    }

    public WizardTaskState init(WizardFrame wizardFrame) throws WizardTaskException {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->init(" + wizardFrame + ")");
        }
        this.userProfilesPlugin = UserProfTasklet.loadPlugin();
        if (this.userProfilesPlugin == null) {
            new AusMicrocodeLog(LOG_INFO_TASK, 2).writeEntry(null);
            throw new WizardTaskException(new LocalizableText("com.ibm.hsc.common.bundles.NewUsersText", "INTERNAL_ERROR_TITLE", null), new HSCLocalizableMsg(MsgType.ERROR_MESSAGE, "W", "com.ibm.hsc.common.bundles.GuidedSetupWizardMessages", "0208", null));
        }
        this.taskRolesList = this.userProfilesPlugin.getRoles(1);
        if (this.taskRolesList == null) {
            new AusMicrocodeLog(LOG_INFO_TASK, 3).writeEntry(null);
            throw new WizardTaskException(new LocalizableText("com.ibm.hsc.common.bundles.NewUsersText", "INTERNAL_ERROR_TITLE", null), new HSCLocalizableMsg(MsgType.ERROR_MESSAGE, "W", "com.ibm.hsc.common.bundles.GuidedSetupWizardMessages", "0209", null));
        }
        this.curUsersList = this.buildTopUsers();
        return new WizardTaskState(new WizardTaskPanel("com.ibm.hsc.iw.tasks.newusers.res.NewUsers", "new_users1", "com.ibm.hsc.iw.tasks.newusers.NewUsers1Bean", new LocalizableText("com.ibm.hsc.common.bundles.NewUsersText", "TITLE_BAR_EXT")), new NewUsersState(this.taskRolesList, this.curUsersList));
    }

    public void exit() {
    }

    public WizardTaskState nextButtonHit(Serializable serializable) throws WizardTaskException {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->nextButtonHit()");
        }
        NewUsersState newUsersState = (NewUsersState)serializable;
        String[] stringArray = null;
        if (newUsersState.getActivePanelName().equals("new_users1")) {
            if (Trace.LEVEL >= 3) {
                Trace.trace(TRACE_MASKD, "nextButtonHit() - Panel 1");
            }
            if (newUsersState.getNewUsersIndex() > 0) {
                if (Trace.LEVEL >= 3) {
                    Trace.trace(TRACE_MASKD, "nextButtonHit() - Panel 1 - User entered.");
                }
                newUsersState.setActivePanelName("new_users2");
                return new WizardTaskState(new WizardTaskPanel("com.ibm.hsc.iw.tasks.newusers.res.NewUsers", "new_users2", "com.ibm.hsc.iw.tasks.newusers.NewUsers2Bean", new LocalizableText("com.ibm.hsc.common.bundles.NewUsersText", "TITLE_BAR_EXT")), serializable);
            }
            if (Trace.LEVEL >= 3) {
                Trace.trace(TRACE_MASKD, "nextButtonHit() - Panel 1 - No User entered.(index 0)");
            }
            return new WizardTaskState(null, serializable);
        }
        if (Trace.LEVEL >= 3) {
            Trace.trace(TRACE_MASKD, "nextButtonHit() - Panel 2");
        }
        newUsersState.setActivePanelName("new_users1");
        stringArray = newUsersState.getNewUsersRadioButton();
        if (stringArray[0] != null && stringArray[0].endsWith("RadioButton2")) {
            if (Trace.LEVEL >= 3) {
                Trace.trace(TRACE_MASKD, "nextButtonHit() - Panel 2 - No more users to enter.");
            }
            return new WizardTaskState(null, serializable);
        }
        if (Trace.LEVEL >= 3) {
            Trace.trace(TRACE_MASKD, "nextButtonHit() - Panel 2 - Query for more users.");
            if (stringArray[0] == null) {
                Trace.trace(TRACE_MASKD, "nextButtonHit() - Panel 2 - radio button NULL ptr");
            } else {
                Trace.trace(TRACE_MASKD, "nextButtonHit() - Panel 2 - radio button " + stringArray[0]);
            }
        }
        return new WizardTaskState(new WizardTaskPanel("com.ibm.hsc.iw.tasks.newusers.res.NewUsers", "new_users1", "com.ibm.hsc.iw.tasks.newusers.NewUsers1Bean", new LocalizableText("com.ibm.hsc.common.bundles.NewUsersText", "TITLE_BAR_EXT")), serializable);
    }

    public Object backButtonHit(Serializable serializable) {
        NewUsersState newUsersState = (NewUsersState)serializable;
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->backButtonHit()");
        }
        return newUsersState;
    }

    public Object backedIntoPanel(WizardTaskState wizardTaskState) {
        NewUsersState newUsersState = (NewUsersState)wizardTaskState.getToken();
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "-->backedIntoPanel()");
        }
        if (newUsersState.getActivePanelName().equals("new_users2")) {
            newUsersState.setActivePanelName("new_users1");
        } else if (newUsersState.getNewUsersIndex() > 0) {
            newUsersState.setActivePanelName("new_users2");
        }
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<--backedIntoPanel()");
        }
        return newUsersState;
    }

    public LocalizableText[] prepareToCommit(Object object) {
        int n;
        NewUsersState newUsersState = (NewUsersState)object;
        LocalizableText[] localizableTextArray = null;
        Object[][] objectArray = null;
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->prepareToCommit()");
        }
        if ((n = newUsersState.getNewUsersIndex()) > 0) {
            objectArray = new String[n][2];
            localizableTextArray = new LocalizableText[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i][0] = newUsersState.getNewUsername(i);
                objectArray[i][1] = newUsersState.getNewRole(i);
                if (Trace.LEVEL >= 3) {
                    Trace.trace(TRACE_MASKD, "UserId: " + objectArray[i][0] + " role: " + objectArray[1]);
                }
                localizableTextArray[i] = new LocalizableText("com.ibm.hsc.common.bundles.NewUsersText", "COMMIT_DESCRIPTION", objectArray[i]);
            }
            return localizableTextArray;
        }
        return null;
    }

    public WizardCommitStatus commit(Object object) {
        NewUsersState newUsersState = (NewUsersState)object;
        boolean bl = false;
        boolean bl2 = true;
        HSCLocalizableMsg[] hSCLocalizableMsgArray = null;
        Object[][] objectArray = null;
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "-->commit()");
        }
        int n = newUsersState.getNewUsersIndex();
        hSCLocalizableMsgArray = new HSCLocalizableMsg[n];
        objectArray = new String[n][2];
        for (int i = 0; i < n; ++i) {
            bl = this.addUserid(newUsersState.getNewUsername(i), newUsersState.getNewPassword(i), newUsersState.getNewRole(i));
            objectArray[i][0] = newUsersState.getNewUsername(i);
            objectArray[i][1] = newUsersState.getNewRole(i);
            if (bl) {
                hSCLocalizableMsgArray[i] = new HSCLocalizableMsg(MsgType.INFORMATION_MESSAGE, "W", "com.ibm.hsc.common.bundles.GuidedSetupWizardMessages", "0204", objectArray[i]);
                continue;
            }
            bl2 = false;
            hSCLocalizableMsgArray[i] = new HSCLocalizableMsg(MsgType.ERROR_MESSAGE, "W", "com.ibm.hsc.common.bundles.GuidedSetupWizardMessages", "0205", objectArray[i]);
        }
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<--commit()");
        }
        return new WizardCommitStatus(bl2, hSCLocalizableMsgArray);
    }

    private boolean addUserid(String string, String string2, String string3) {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "-->addUserid()");
        }
        byte[] byArray = string2.getBytes();
        UserAttributes userAttributes = new UserAttributes(string, byArray, new LocalizableText("new user from Wizard"));
        ArrayList<Object> arrayList = new ArrayList<Object>();
        RoleTree roleTree = null;
        for (int i = 0; i < this.taskRolesList.size(); ++i) {
            roleTree = (RoleTree)this.taskRolesList.get(i);
            if (!roleTree.getName().toString().equals(string3)) continue;
            arrayList.add(roleTree.getKey());
            i = this.taskRolesList.size();
        }
        userAttributes.setRoles(1, arrayList);
        try {
            this.userProfilesPlugin.addUser(userAttributes);
        }
        catch (Exception exception) {
            if (Trace.LEVEL >= 1) {
                Trace.trace(TRACE_MASKT, "<--addUser returning FALSE. Exception caught:" + exception);
            }
            exception.printStackTrace();
            return false;
        }
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<--addUserid()");
        }
        return true;
    }

    public List buildTopUsers() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-->UserProfTasklet.buildTopUsers() ");
        }
        ArrayList<UserAttributes> arrayList = new ArrayList<UserAttributes>();
        UserAttributes[] userAttributesArray = this.userProfilesPlugin.getUsers();
        for (int i = 0; i < userAttributesArray.length; ++i) {
            arrayList.add(userAttributesArray[i]);
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<--UserProfTasklet.buildTopUsers() ");
        }
        return arrayList;
    }
}

